/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.world.World;
import java.util.List;
import java.util.ListIterator;

public class BetterFish
extends EntityLiving {
    float myspeed = 0.0f;
    public int updown = 0;
    public int movesearchdist = 15;

    public BetterFish(World w) {
        super(w);
        this.maxrenderdist = 128;
        this.height = 0.65f;
        this.width = 0.45f;
        this.uniquename = "DangerZone:BetterFish";
        this.moveSpeed = 0.25f;
        this.setMaxHealth(3.0f);
        this.setHealth(3.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 50;
        this.setExperience(3);
        this.canSwim = true;
        this.takesFallDamage = true;
        this.canBreateUnderWater = true;
        this.targetLiquidOnly = true;
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = false;
        this.nighttimedespawn = true;
        this.myspeed = this.moveSpeed;
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        return "DangerZone:little_splash";
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:little_splat";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:little_splat";
    }

    @Override
    public void doAttackFrom(Entity e, int dt, float pain) {
        if (dt == 6) {
            return;
        }
        super.doAttackFrom(e, dt, pain);
    }

    @Override
    public void doEntityAction(float deltaT) {
        int keep_trying = 25;
        int frq = this.movefrequency;
        if (this.isMad() && (frq /= 4) < 2) {
            frq = 2;
        }
        this.do_swarm_despawn();
        if (this.world.rand.nextInt(200) == 1) {
            this.heal(0.1f);
        }
        if (this.enable_hostile) {
            ++this.searchcounter;
            if (this.searchcounter >= 10) {
                this.searchcounter = this.world.rand.nextInt(4);
                if (this.hurtMe != null && this.hurtMe.deadflag) {
                    this.hurtMe = null;
                }
                if (this.world.rand.nextInt(30) == 1) {
                    this.hurtMe = null;
                }
                this.targetentity = this.hurtMe;
                if (this.targetentity == null) {
                    this.targetentity = this.findSomethingToAttack();
                }
                if (this.targetentity != null) {
                    this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy, this.targetentity.posz);
                    this.setAttacking(true);
                    this.myspeed = this.moveSpeed + this.moveSpeed * this.world.rand.nextFloat() * 0.75f;
                    frq *= 2;
                } else {
                    this.setAttacking(false);
                }
            }
            if (this.targetentity != null && this.world.rand.nextInt(5) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
                float dmg = this.getAttackDamage();
                int dt = 4;
                this.targetentity.doAttackFrom(this, dt, dmg);
                this.world.playSound(this.getAttackSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
            }
        }
        if (!this.isMad() && !this.deadflag && this.world.rand.nextInt(50) == 1) {
            this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
        }
        int bid = 0;
        if (this.target != null && (bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) == Blocks.waterstatic.blockID && this.wouldBump(this.posx + (double)(this.motionx * deltaT), this.posy + (double)(this.motiony * deltaT) + (double)(this.getHeight() / 2.0f), this.posz + (double)(this.motionz * deltaT), this.getWidth())) {
            bid = 0;
        }
        if (this.world.rand.nextInt(100) == 1) {
            this.updown = this.world.rand.nextInt(3);
            if (this.world.rand.nextBoolean()) {
                this.updown = -this.updown;
            }
            this.updown -= 2;
        }
        if (this.target != null && this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < (double)(3.5f + this.getWidth())) {
            this.target = null;
        }
        if (bid != Blocks.waterstatic.blockID || this.world.rand.nextInt(frq) == 1) {
            if (this.target == null) {
                this.target = new TargetHelper(this.posx, this.posy, this.posz);
            }
            bid = 0;
            while (bid != Blocks.waterstatic.blockID && keep_trying != 0) {
                if (this.isSwarming()) {
                    this.target.setTarget(this.posx + (double)this.world.rand.nextInt(this.movesearchdist), this.posy + (double)(this.world.rand.nextInt(7) - 4) + (double)this.updown, this.posz + (double)this.world.rand.nextInt(this.movesearchdist));
                } else {
                    this.target.setTarget(this.posx + (double)this.world.rand.nextInt(this.movesearchdist) - (double)this.world.rand.nextInt(this.movesearchdist), this.posy + (double)(this.world.rand.nextInt(7) - 4) + (double)this.updown, this.posz + (double)this.world.rand.nextInt(this.movesearchdist) - (double)this.world.rand.nextInt(this.movesearchdist));
                }
                bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)(this.target.targety + 0.5), (int)this.target.targetz);
                if (bid == Blocks.waterstatic.blockID && !this.CanProbablySee(this.dimension, this.target.targetx, this.target.targety, this.target.targetz, (int)Math.sqrt((this.posx - this.target.targetx) * (this.posx - this.target.targetx) + (this.posz - this.target.targetz) * (this.posz - this.target.targetz) + (this.posy - this.target.targety) * (this.posy - this.target.targety)))) {
                    bid = 0;
                }
                --keep_trying;
                this.myspeed = this.moveSpeed * this.world.rand.nextFloat() * 1.5f;
                if (!this.isMad()) continue;
                this.myspeed += this.moveSpeed;
            }
        }
        if (this.enable_buddy && this.world.rand.nextInt(this.findbuddyfrequency) == 1) {
            List<Entity> nearby_list = null;
            int nbuddy = 0;
            double totaly = 0.0;
            double totalz = 0.0;
            double totalx = 0.0;
            nearby_list = DangerZone.server.entityManager.findEntitiesInRange(this.findbuddydistance, this.dimension, this.posx, this.posy, this.posz);
            if (nearby_list != null && !nearby_list.isEmpty()) {
                Entity e = null;
                ListIterator<Entity> li = nearby_list.listIterator();
                while (li.hasNext()) {
                    e = li.next();
                    if (e == this || !this.isBuddy(e)) continue;
                    totalx += e.posx;
                    totalz += e.posz;
                    totaly += e.posy;
                    ++nbuddy;
                }
                if (nbuddy > 0) {
                    this.target = new TargetHelper(totalx / (double)nbuddy, totaly / (double)nbuddy - 1.0, totalz / (double)nbuddy);
                }
            }
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz)) != Blocks.waterstatic.blockID) {
            this.motiony = !Blocks.isSolid(bid) ? (this.motiony -= 0.2f * deltaT) : (this.motiony += 0.12f * deltaT);
            if (bid != Blocks.water.blockID) {
                if (this.world.rand.nextInt(50) == 1) {
                    this.doAttackFrom(null, 13, 0.1f);
                }
                this.setInLiquid(false);
            } else {
                this.setInLiquid(true);
            }
        } else {
            this.setInLiquid(true);
        }
        if (this.target != null) {
            float dy = (float)(this.target.targety - this.posy);
            this.motiony += 0.075f * deltaT;
            if ((dy /= 20.0f) > 0.2f) {
                dy = 0.2f;
            }
            if (dy < -0.2f) {
                dy = -0.2f;
            }
            this.motiony += dy;
            if (this.motiony > 1.0f) {
                this.motiony = 1.0f;
            }
            if (this.motiony < -1.0f) {
                this.motiony = -1.0f;
            }
            float cdir = (float)Math.toRadians(this.rotation_yaw);
            float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
            float ddiff = tdir - cdir;
            while ((double)ddiff > Math.PI) {
                ddiff = (float)((double)ddiff - Math.PI * 2);
            }
            while ((double)ddiff < -Math.PI) {
                ddiff = (float)((double)ddiff + Math.PI * 2);
            }
            this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
            float speedadjust = 1.0f;
            float effectspeed = this.getTotalEffect(1);
            if (effectspeed > 1.0f) {
                speedadjust *= effectspeed;
            }
            if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
                speedadjust /= effectspeed;
            }
            this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
            this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
            if (this.getInLiquid()) {
                Utils.SpawnBubblesAlongPath(this);
            }
        }
        if (Math.sqrt(this.motionx * this.motionx + this.motionz * this.motionz) > (double)(this.myspeed * 1.1f)) {
            this.motionx *= 0.85f;
            this.motionz *= 0.85f;
            this.motiony *= 0.85f;
        }
        if (this.enable_lookaround) {
            this.doLookAction();
        }
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        int blk = this.world.getblock(e.dimension, (int)e.posx, (int)e.posy, (int)e.posz);
        if (blk != Blocks.waterstatic.blockID) {
            return false;
        }
        if (e instanceof Player && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e.temperament == 1 && this.CanProbablySeeEntity(e);
    }
}

